import { ApplicationShell } from "@/components/layout/application.shell";
import { ApplicationSidebar } from "@/components/layout/application.sidebar";
import { ApplicationUser } from "@/features/auth/components/application.user";
import { getCurrentUserFromServer } from "@/features/auth/lib/session.amplify";
import { StatusRevalidateBannerApplicationSidebar } from "@/features/feeds/components/status.revalidate-banner-application-sidebar";

export default async function SiteLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  const user = await getCurrentUserFromServer()

  return (
    <ApplicationShell>
      {{
        content: children,
        sidebar: (
          <ApplicationSidebar
            userItem={<ApplicationUser user={user} />}
            notification={(
              <StatusRevalidateBannerApplicationSidebar />
            )}
          />
        )
      }}
    </ApplicationShell>
  );
}
